import type { INodeProperties } from 'n8n-workflow';

export const leadOperations: INodeProperties[] = [
	{
		displayName: 'Operation',
		name: 'operation',
		type: 'options',
		noDataExpression: true,
		default: 'create',
		options: [
			{
				name: 'Create',
				value: 'create',
				action: 'Create a lead',
			},
			{
				name: 'Delete',
				value: 'delete',
				action: 'Delete a lead',
			},
			{
				name: 'Get',
				value: 'get',
				action: 'Get a lead',
			},
			{
				name: 'Unsubscribe',
				value: 'unsubscribe',
				action: 'Unsubscribe a lead',
			},
		],
		displayOptions: {
			show: {
				resource: ['lead'],
			},
		},
	},
];

export const leadFields: INodeProperties[] = [
	// ----------------------------------
	//        lead: create
	// ----------------------------------
	{
		displayName: 'Campaign Name or ID',
		name: 'campaignId',
		type: 'options',
		required: true,
		default: [],
		typeOptions: {
			loadOptionsMethod: 'getCampaigns',
		},
		description:
			'ID of the campaign to create the lead under. Choose from the list, or specify an ID using an <a href="https://docs.n8n.io/code/expressions/">expression</a>.',
		displayOptions: {
			show: {
				resource: ['lead'],
				operation: ['create'],
			},
		},
	},
	{
		displayName: 'Email',
		name: 'email',
		type: 'string',
		placeholder: 'name@email.com',
		default: '',
		description: 'Email of the lead to create',
		displayOptions: {
			show: {
				resource: ['lead'],
				operation: ['create'],
			},
		},
	},
	{
		displayName: 'Additional Fields',
		name: 'additionalFields',
		type: 'collection',
		placeholder: 'Add Field',
		default: {},
		displayOptions: {
			show: {
				resource: ['lead'],
				operation: ['create'],
			},
		},
		options: [
			{
				displayName: 'Company Name',
				name: 'companyName',
				type: 'string',
				default: '',
				description: 'Company name of the lead to create',
			},
			{
				displayName: 'Company Domain',
				name: 'companyDomain',
				type: 'string',
				default: '',
				description: 'Company domain of the lead to create',
			},
			{
				displayName: 'Deduplicate',
				name: 'deduplicate',
				type: 'boolean',
				default: false,
				description:
					'Whether to do not insert if this email is already present in another campaign',
			},
			{
				displayName: 'Find Email',
				name: 'findEmail',
				type: 'boolean',
				default: false,
				description: 'Whether to find verified email',
			},
			{
				displayName: 'Find Phone',
				name: 'findPhone',
				type: 'boolean',
				default: false,
				description: 'Whether to find phone number',
			},
			{
				displayName: 'First Name',
				name: 'firstName',
				type: 'string',
				default: '',
				description: 'First name of the lead to create',
			},
			{
				displayName: 'Icebreaker',
				name: 'icebreaker',
				type: 'string',
				default: '',
				description: 'Icebreaker of the lead to create',
			},
			{
				displayName: 'Job Title',
				name: 'jobTitle',
				type: 'string',
				default: '',
				description: 'Job title of the lead to create',
			},
			{
				displayName: 'Last Name',
				name: 'lastName',
				type: 'string',
				default: '',
				description: 'Last name of the lead to create',
			},
			{
				displayName: 'LinkedIn Enrichment',
				name: 'linkedinEnrichment',
				type: 'boolean',
				default: false,
				description: 'Whether to run the LinkedIn enrichment',
			},

			{
				displayName: 'LinkedIn URL',
				name: 'linkedinUrl',
				type: 'string',
				default: '',
				description: 'LinkedIn URL of the lead to create',
			},
			{
				displayName: 'Phone',
				name: 'phone',
				type: 'string',
				default: '',
				description: 'Phone number of the lead to create',
			},
			{
				displayName: 'Picture URL',
				name: 'picture',
				type: 'string',
				default: '',
				description: 'Picture URL of the lead to create',
			},
			{
				displayName: 'Verify Email',
				name: 'verifyEmail',
				type: 'boolean',
				default: false,
				description: 'Whether to verify existing email (debounce)',
			},
		],
	},

	// ----------------------------------
	//        lead: delete
	// ----------------------------------
	{
		displayName: 'Campaign Name or ID',
		name: 'campaignId',
		type: 'options',
		required: true,
		default: [],
		typeOptions: {
			loadOptionsMethod: 'getCampaigns',
		},
		description:
			'ID of the campaign to remove the lead from. Choose from the list, or specify an ID using an <a href="https://docs.n8n.io/code/expressions/">expression</a>.',
		displayOptions: {
			show: {
				resource: ['lead'],
				operation: ['delete'],
			},
		},
	},
	{
		displayName: 'Email',
		name: 'email',
		type: 'string',
		placeholder: 'name@email.com',
		default: '',
		description: 'Email of the lead to delete',
		displayOptions: {
			show: {
				resource: ['lead'],
				operation: ['delete'],
			},
		},
	},

	// ----------------------------------
	//           lead: get
	// ----------------------------------
	{
		displayName: 'Email',
		name: 'email',
		type: 'string',
		placeholder: 'name@email.com',
		default: '',
		description: 'Email of the lead to retrieve',
		displayOptions: {
			show: {
				resource: ['lead'],
				operation: ['get'],
			},
		},
	},

	// ----------------------------------
	//        lead: unsubscribe
	// ----------------------------------
	{
		displayName: 'Campaign Name or ID',
		name: 'campaignId',
		type: 'options',
		required: true,
		default: [],
		typeOptions: {
			loadOptionsMethod: 'getCampaigns',
		},
		description:
			'ID of the campaign to unsubscribe the lead from. Choose from the list, or specify an ID using an <a href="https://docs.n8n.io/code/expressions/">expression</a>.',
		displayOptions: {
			show: {
				resource: ['lead'],
				operation: ['unsubscribe'],
			},
		},
	},
	{
		displayName: 'Email',
		name: 'email',
		type: 'string',
		placeholder: 'name@email.com',
		default: '',
		description: 'Email of the lead to unsubscribe',
		displayOptions: {
			show: {
				resource: ['lead'],
				operation: ['unsubscribe'],
			},
		},
	},
];
