import type { IconDefinition, IconName, IconPrefix } from '@fortawesome/fontawesome-svg-core';

export const faVariable: IconDefinition = {
	prefix: 'fas' as IconPrefix,
	iconName: 'variable' as IconName,
	icon: [
		52,
		52,
		[],
		'e001',
		'M42.6,17.8c2.4,0,7.2-2,7.2-8.4c0-6.4-4.6-6.8-6.1-6.8c-2.8,0-5.6,2-8.1,6.3c-2.5,4.4-5.3,9.1-5.3,9.1 l-0.1,0c-0.6-3.1-1.1-5.6-1.3-6.7c-0.5-2.7-3.6-8.4-9.9-8.4c-6.4,0-12.2,3.7-12.2,3.7l0,0C5.8,7.3,5.1,8.5,5.1,9.9 c0,2.1,1.7,3.9,3.9,3.9c0.6,0,1.2-0.2,1.7-0.4l0,0c0,0,4.8-2.7,5.9,0c0.3,0.8,0.6,1.7,0.9,2.7c1.2,4.2,2.4,9.1,3.3,13.5l-4.2,6 c0,0-4.7-1.7-7.1-1.7s-7.2,2-7.2,8.4s4.6,6.8,6.1,6.8c2.8,0,5.6-2,8.1-6.3c2.5-4.4,5.3-9.1,5.3-9.1c0.8,4,1.5,7.1,1.9,8.5 c1.6,4.5,5.3,7.2,10.1,7.2c0,0,5,0,10.9-3.3c1.4-0.6,2.4-2,2.4-3.6c0-2.1-1.7-3.9-3.9-3.9c-0.6,0-1.2,0.2-1.7,0.4l0,0 c0,0-4.2,2.4-5.6,0.5c-1-2-1.9-4.6-2.6-7.8c-0.6-2.8-1.3-6.2-2-9.5l4.3-6.2C35.5,16.1,40.2,17.8,42.6,17.8z',
	],
};

export const faVault: IconDefinition = {
	prefix: 'fas' as IconPrefix,
	iconName: 'vault' as IconName,
	icon: [
		576,
		512,
		[],
		'e006',
		'M64 0C28.7 0 0 28.7 0 64v352c0 35.3 28.7 64 64 64h16l16 32h64l16-32h224l16 32h64l16-32h16c35.3 0 64-28.7 64-64V64c0-35.3-28.7-64-64-64H64zm160 320a80 80 0 1 0 0-160a80 80 0 1 0 0 160zm0-240a160 160 0 1 1 0 320a160 160 0 1 1 0-320zm256 141.3V336c0 8.8-7.2 16-16 16s-16-7.2-16-16V221.3c-18.6-6.6-32-24.4-32-45.3c0-26.5 21.5-48 48-48s48 21.5 48 48c0 20.9-13.4 38.7-32 45.3z',
	],
};

export const faXmark: IconDefinition = {
	prefix: 'fas' as IconPrefix,
	iconName: 'xmark' as IconName,
	icon: [
		400,
		400,
		[],
		'',
		'M342.6 150.6c12.5-12.5 12.5-32.8 0-45.3s-32.8-12.5-45.3 0L192 210.7 86.6 105.4c-12.5-12.5-32.8-12.5-45.3 0s-12.5 32.8 0 45.3L146.7 256 41.4 361.4c-12.5 12.5-12.5 32.8 0 45.3s32.8 12.5 45.3 0L192 301.3 297.4 406.6c12.5 12.5 32.8 12.5 45.3 0s12.5-32.8 0-45.3L237.3 256 342.6 150.6z',
	],
};

export const faRefresh: IconDefinition = {
	prefix: 'fas' as IconPrefix,
	iconName: 'refresh' as IconName,

	icon: [
		12,
		13,
		[],
		'',
		'M8.67188 3.64062C7.94531 2.96094 6.98438 2.5625 5.97656 2.5625C4.17188 2.58594 2.60156 3.82812 2.17969 5.53906C2.13281 5.67969 2.01562 5.75 1.89844 5.75H0.5625C0.375 5.75 0.234375 5.60938 0.28125 5.42188C0.773438 2.72656 3.14062 0.6875 6 0.6875C7.54688 0.6875 8.95312 1.32031 10.0078 2.30469L10.8516 1.46094C11.2031 1.10938 11.8125 1.36719 11.8125 1.85938V5C11.8125 5.32812 11.5547 5.5625 11.25 5.5625H8.08594C7.59375 5.5625 7.33594 4.97656 7.6875 4.625L8.67188 3.64062ZM0.75 7.4375H3.89062C4.38281 7.4375 4.64062 8.04688 4.28906 8.39844L3.30469 9.38281C4.03125 10.0625 4.99219 10.4609 6 10.4609C7.80469 10.4375 9.375 9.19531 9.79688 7.48438C9.84375 7.34375 9.96094 7.27344 10.0781 7.27344H11.4141C11.6016 7.27344 11.7422 7.41406 11.6953 7.60156C11.2031 10.2969 8.83594 12.3125 6 12.3125C4.42969 12.3125 3.02344 11.7031 1.96875 10.7188L1.125 11.5625C0.773438 11.9141 0.1875 11.6562 0.1875 11.1641V8C0.1875 7.69531 0.421875 7.4375 0.75 7.4375Z',
	],
};

export const faTriangle: IconDefinition = {
	prefix: 'fas',
	iconName: 'triangle' as IconName,
	icon: [
		512,
		512,
		[],
		'',
		'M214.433 56C232.908 23.9999 279.096 24.0001 297.571 56L477.704 368C496.18 400 473.085 440 436.135 440H75.8685C38.918 440 15.8241 400 34.2993 368L214.433 56ZM256.002 144L131.294 360H380.709L256.002 144Z',
	],
};

export const statusCompleted: IconDefinition = {
	prefix: 'fas',
	iconName: 'status-completed' as IconName,
	icon: [
		14,
		14,
		[],
		'',
		'M 14 7 C 14 10.866 10.866 14 7 14 C 3.134 14 0 10.866 0 7 C 0 3.134 3.134 0 7 0 C 10.866 0 14 3.134 14 7 Z M 2.575 7.728 L 5.782 10.935 L 11.489 5.228 L 10.075 3.814 L 5.782 8.107 L 3.989 6.314 L 2.575 7.728 Z',
	],
};

export const statusWaiting: IconDefinition = {
	prefix: 'fas',
	iconName: 'status-waiting' as IconName,
	icon: [
		14,
		14,
		[],
		'',
		'M7 14C10.866 14 14 10.866 14 7C14 3.13401 10.866 0 7 0C3.13401 0 0 3.13401 0 7C0 10.866 3.13401 14 7 14ZM7 12C4.23858 12 2 9.76142 2 7C2 4.23858 4.23858 2 7 2C9.76142 2 12 4.23858 12 7C12 9.76142 9.76142 12 7 12ZM6 3V8H11C11 5.23858 8.76142 3 6 3Z',
	],
};

export const statusError: IconDefinition = {
	prefix: 'fas',
	iconName: 'status-error' as IconName,
	icon: [
		14,
		14,
		[],
		'',
		'M 4.207 2.793 L 7 5.586 L 9.793 2.793 L 11.207 4.207 L 8.414 7 L 11.207 9.793 L 9.793 11.207 L 7 8.414 L 4.207 11.207 L 2.793 9.793 L 5.586 7 L 2.793 4.207 L 4.207 2.793 Z M 7 0 C 3.134 0 0 3.134 0 7 C 0 10.866 3.134 14 7 14 C 10.866 14 14 10.866 14 7 C 14 3.134 10.866 0 7 0 Z',
	],
};

export const statusCanceled: IconDefinition = {
	prefix: 'fas',
	iconName: 'status-canceled' as IconName,
	icon: [
		14,
		14,
		[],
		'',
		'M 14 7 C 14 10.866 10.866 14 7 14 C 3.134 14 0 10.866 0 7 C 0 3.134 3.134 0 7 0 C 10.866 0 14 3.134 14 7 Z M 11.243 6 L 2.758 6 L 2.758 8 L 11.243 8 L 11.243 6 Z',
	],
};

export const statusNew: IconDefinition = {
	prefix: 'fas',
	iconName: 'status-new' as IconName,
	icon: [
		14,
		14,
		[],
		'',
		'M 14 7.006 C 14 8.867 13.162 10.744 11.95 11.956 C 10.738 13.168 8.861 14.006 7 14.006 C 5.139 14.006 3.262 13.168 2.05 11.956 C 0.838 10.744 0 8.867 0 7.006 C 0 5.145 0.838 3.268 2.05 2.056 C 3.262 0.844 5.139 0.006 7 0.006 C 8.861 0.006 10.738 0.844 11.95 2.056 C 13.162 3.268 14 5.145 14 7.006 Z M 10.536 3.47 C 9.576 2.511 8.453 2.006 7 2.006 C 5.547 2.006 4.424 2.511 3.464 3.47 C 2.505 4.43 2 5.553 2 7.006 C 2 8.459 2.505 9.582 3.464 10.542 C 4.424 11.501 5.547 12.006 7 12.006 C 8.453 12.006 9.576 11.501 10.536 10.542 C 11.495 9.582 12 8.459 12 7.006 C 12 5.553 11.495 4.43 10.536 3.47 Z',
	],
};

export const statusUnknown: IconDefinition = {
	prefix: 'fas',
	iconName: 'status-unknown' as IconName,
	icon: [
		14,
		14,
		[],
		'',
		'M13.8668 8.36613L11.9048 7.978C11.967 7.66329 12 7.33649 12 7C12 6.66351 11.967 6.3367 11.9048 6.022L13.8668 5.63387C13.9542 6.07571 14 6.5325 14 7C14 7.4675 13.9542 7.92429 13.8668 8.36613ZM12.821 3.11069L11.159 4.22333C10.7934 3.67721 10.3228 3.2066 9.77667 2.84098L10.8893 1.17904C11.6527 1.6901 12.3099 2.34733 12.821 3.11069ZM8.36613 0.133238L7.978 2.09521C7.66329 2.03296 7.33649 2 7 2C6.66351 2 6.3367 2.03296 6.022 2.09521L5.63387 0.133238C6.07571 0.0458286 6.5325 0 7 0C7.4675 0 7.92429 0.0458285 8.36613 0.133238ZM3.11069 1.17904L4.22333 2.84098C3.67721 3.2066 3.2066 3.67721 2.84098 4.22333L1.17904 3.11069C1.6901 2.34733 2.34733 1.6901 3.11069 1.17904ZM0.133238 5.63387C0.0458285 6.07571 0 6.5325 0 7C0 7.4675 0.0458286 7.92429 0.133238 8.36613L2.09521 7.978C2.03296 7.6633 2 7.33649 2 7C2 6.66351 2.03296 6.33671 2.09521 6.022L0.133238 5.63387ZM1.17904 10.8893L2.84098 9.77667C3.2066 10.3228 3.67721 10.7934 4.22333 11.159L3.11069 12.821C2.34733 12.3099 1.6901 11.6527 1.17904 10.8893ZM5.63387 13.8668L6.022 11.9048C6.33671 11.967 6.66351 12 7 12C7.33649 12 7.6633 11.967 7.978 11.9048L8.36613 13.8668C7.92429 13.9542 7.4675 14 7 14C6.5325 14 6.07571 13.9542 5.63387 13.8668ZM10.8893 12.821L9.77667 11.159C10.3228 10.7934 10.7934 10.3228 11.159 9.77667L12.821 10.8893C12.3099 11.6527 11.6527 12.3099 10.8893 12.821Z',
	],
};

export const statusWarning: IconDefinition = {
	prefix: 'fas',
	iconName: 'status-warning' as IconName,
	icon: [
		14,
		14,
		[],
		'',
		'M 14 7 C 14 10.866 10.866 14 7 14 C 3.134 14 0 10.866 0 7 C 0 3.134 3.134 0 7 0 C 10.866 0 14 3.134 14 7 Z M 6.5 9 C 6.224 9 6 9.224 6 9.5 L 6 10.5 C 6 10.776 6.224 11 6.5 11 L 7.5 11 C 7.776 11 8 10.776 8 10.5 L 8 9.5 C 8 9.224 7.776 9 7.5 9 L 6.5 9 Z M 6.5 3 C 6.224 3 6 3.224 6 3.5 L 6 7.5 C 6 7.776 6.224 8 6.5 8 L 7.5 8 C 7.776 8 8 7.776 8 7.5 L 8 3.5 C 8 3.224 7.776 3 7.5 3 L 6.5 3 Z',
	],
};

export const faPopOut: IconDefinition = {
	prefix: 'fas',
	iconName: 'pop-out' as IconName,
	icon: [
		16,
		16,
		[],
		'',
		'M13.3333 12.5525V12.4489C14.2278 12.0756 14.8571 11.1925 14.8571 10.1632V3.61924C14.8571 2.96252 14.5962 2.3327 14.1318 1.86832C13.6675 1.40395 13.0376 1.14307 12.3809 1.14307H5.90473C5.38113 1.14296 4.87098 1.30883 4.44756 1.61684C4.02414 1.92485 3.70926 2.35915 3.54816 2.85734H3.39501C2.70016 2.85734 2.10892 3.10191 1.70206 3.5842C1.30739 4.05124 1.14282 4.67372 1.14282 5.33352V12.0002C1.14282 12.8078 1.43463 13.5346 1.98854 14.0573C2.54168 14.5777 3.30892 14.8535 4.19044 14.8535H7.17711L10.2826 14.8573H10.2842C11.0278 14.8611 11.7645 14.7049 12.336 14.3392C12.9303 13.9582 13.3333 13.3525 13.3333 12.5525ZM3.39501 4.0002H3.42854V10.1625C3.42854 10.8192 3.68942 11.449 4.1538 11.9134C4.61817 12.3777 5.248 12.6386 5.90473 12.6386H12.1874C12.163 12.9571 12.003 13.1948 11.7196 13.3761C11.3897 13.588 10.8891 13.7175 10.2887 13.7144H10.2857L7.17558 13.7106H4.19044C3.54816 13.7106 3.07806 13.5125 2.7733 13.2253C2.47006 12.9403 2.28568 12.5259 2.28568 12.0002V5.33352C2.28568 4.84971 2.40758 4.52057 2.5752 4.32096C2.73139 4.13658 2.98054 4.0002 3.39501 4.0002ZM8.01673 3.80972H11.619C11.7706 3.80972 11.9159 3.86992 12.0231 3.97709C12.1302 4.08425 12.1904 4.22959 12.1904 4.38115V7.98418C12.1904 8.13573 12.1302 8.28107 12.0231 8.38823C11.9159 8.4954 11.7706 8.5556 11.619 8.5556C11.4675 8.5556 11.3221 8.4954 11.215 8.38823C11.1078 8.28107 11.0476 8.13573 11.0476 7.98418V5.76019L7.07044 9.73731C7.0177 9.79186 6.95463 9.83536 6.8849 9.86528C6.81517 9.89519 6.74018 9.91092 6.6643 9.91154C6.58843 9.91217 6.51319 9.89767 6.44298 9.86891C6.37277 9.84014 6.30899 9.79768 6.25536 9.74401C6.20173 9.69033 6.15933 9.62651 6.13063 9.55627C6.10193 9.48603 6.08751 9.41078 6.0882 9.3349C6.0889 9.25903 6.1047 9.18406 6.13468 9.11435C6.16466 9.04465 6.20822 8.98162 6.26282 8.92893L10.24 4.95257H8.01673C7.86517 4.95257 7.71983 4.89237 7.61267 4.7852C7.5055 4.67804 7.4453 4.5327 7.4453 4.38115C7.4453 4.22959 7.5055 4.08425 7.61267 3.97709C7.71983 3.86992 7.86517 3.80972 8.01673 3.80972Z',
	],
};

export const faSchema: IconDefinition = {
	prefix: 'fas',
	iconName: 'schema' as IconName,
	icon: [
		12,
		12,
		[],
		'',
		'M1.63636 0H8.18182C9.08556 0 9.81818 0.732625 9.81818 1.63636C9.81818 2.5401 9.08556 3.27273 8.18182 3.27273H1.63636C0.732626 3.27273 0 2.5401 0 1.63636C0 0.732625 0.732625 0 1.63636 0ZM1.63636 1.09091C1.33512 1.09091 1.09091 1.33512 1.09091 1.63636C1.09091 1.93761 1.33512 2.18182 1.63636 2.18182H8.18182C8.48306 2.18182 8.72727 1.93761 8.72727 1.63636C8.72727 1.33512 8.48306 1.09091 8.18182 1.09091H1.63636Z M7.09091 4.36353H11.4545C12.3583 4.36353 13.0909 5.09615 13.0909 5.99989C13.0909 6.90363 12.3583 7.63625 11.4545 7.63625H7.09091C6.18717 7.63625 5.45454 6.90363 5.45454 5.99989C5.45454 5.09615 6.18717 4.36353 7.09091 4.36353ZM7.09091 5.45443C6.78966 5.45443 6.54545 5.69864 6.54545 5.99989C6.54545 6.30114 6.78966 6.54534 7.09091 6.54534H11.4545C11.7558 6.54534 12 6.30114 12 5.99989C12 5.69864 11.7558 5.45443 11.4545 5.45443H7.09091Z M7.09091 8.72729H11.4545C12.3583 8.72729 13.0909 9.45992 13.0909 10.3637C13.0909 11.2674 12.3583 12 11.4545 12H7.09091C6.18717 12 5.45454 11.2674 5.45454 10.3637C5.45454 9.45992 6.18717 8.72729 7.09091 8.72729ZM7.09091 9.8182C6.78966 9.8182 6.54545 10.0624 6.54545 10.3637C6.54545 10.6649 6.78966 10.9091 7.09091 10.9091H11.4545C11.7558 10.9091 12 10.6649 12 10.3637C12 10.0624 11.7558 9.8182 11.4545 9.8182H7.09091Z',
	],
};

export const faJSON: IconDefinition = {
	prefix: 'fas',
	iconName: 'json' as IconName,
	icon: [
		12,
		12,
		[],
		'',
		'M10.3019 0C10.542 0 10.7678 0.0476193 10.9791 0.142858C11.1905 0.238096 11.373 0.371429 11.5267 0.542858C11.6805 0.714286 11.8005 0.92381 11.887 1.17143C11.9735 1.40952 12.0167 1.67619 12.0167 1.97143L12.0023 3.38571C12.0023 3.50952 12.0023 3.61429 12.0023 3.7C12.0119 3.78571 12.0263 3.87143 12.0455 3.95714C12.0647 4.04286 12.0936 4.13333 12.132 4.22857C12.18 4.31429 12.2425 4.42857 12.3193 4.57143L12.8237 5.24286C12.9198 5.4619 12.9774 5.66667 12.9966 5.85714C13.0158 6.0381 12.9534 6.25238 12.8093 6.5L12.3337 7.11429C12.2569 7.26667 12.1944 7.39524 12.1464 7.5C12.108 7.60476 12.0791 7.70476 12.0599 7.8C12.0407 7.89524 12.0263 7.99524 12.0167 8.1C12.0167 8.20476 12.0167 8.33333 12.0167 8.48571V9.7C12.0167 10.0048 11.9783 10.2952 11.9014 10.5714C11.8342 10.8381 11.7333 11.0714 11.5988 11.2714C11.4739 11.4714 11.3154 11.6286 11.1233 11.7429C10.9311 11.8571 10.7198 11.9143 10.4892 11.9143L9.49487 12C9.48526 12 9.42282 12 9.30753 12C9.19225 12 9.05775 11.9905 8.90404 11.9714C8.75993 11.9619 8.61103 11.9381 8.45731 11.9C8.31321 11.8714 8.20273 11.819 8.12587 11.7429C8.06823 11.6952 8.0202 11.619 7.98177 11.5143C7.95295 11.4095 7.93854 11.3095 7.93854 11.2143C7.93854 11.0238 8.00579 10.8762 8.14028 10.7714C8.27478 10.6667 8.42369 10.6 8.58701 10.5714C8.75993 10.5333 8.92806 10.5143 9.09137 10.5143H9.71102C10.0953 10.5143 10.2826 10.1857 10.273 9.52857L10.2586 8.22857C10.2586 7.94286 10.2682 7.72381 10.2874 7.57143C10.3163 7.40952 10.3595 7.27619 10.4171 7.17143C10.4844 7.06667 10.566 6.9619 10.6621 6.85714C10.7582 6.75238 10.8735 6.60476 11.008 6.41429C11.0944 6.29048 11.1665 6.19048 11.2241 6.11429C11.2818 6.02857 11.3154 5.94762 11.325 5.87143C11.3346 5.79524 11.3154 5.70952 11.2674 5.61429C11.2289 5.51905 11.1569 5.39048 11.0512 5.22857C10.8975 5 10.7678 4.81905 10.6621 4.68571C10.566 4.55238 10.4844 4.42857 10.4171 4.31429C10.3595 4.2 10.3163 4.08095 10.2874 3.95714C10.2682 3.83333 10.2586 3.66191 10.2586 3.44286V2.41429C10.2586 2.29048 10.2538 2.17143 10.2442 2.05714C10.2442 1.94286 10.225 1.84286 10.1866 1.75714C10.1481 1.67143 10.0857 1.60476 9.99923 1.55714C9.92238 1.50952 9.8119 1.48571 9.66779 1.48571H9.01932C9.00972 1.48571 8.97129 1.48571 8.90404 1.48571C8.83679 1.48571 8.75513 1.48095 8.65906 1.47143C8.56299 1.45238 8.46212 1.42857 8.35644 1.4C8.25076 1.36191 8.1595 1.30476 8.08264 1.22857C8.025 1.18095 7.97697 1.10476 7.93854 1C7.90972 0.895238 7.89531 0.795238 7.89531 0.7C7.89531 0.509524 7.96256 0.361905 8.09705 0.257143C8.23155 0.152381 8.38526 0.0857146 8.55819 0.057143C8.73111 0.0190477 8.89924 0 9.06255 0H10.3019Z M3.93745 0C4.10077 0 4.26889 0.0190477 4.44181 0.057143C4.61474 0.0857146 4.76845 0.152381 4.90295 0.257143C5.03745 0.361905 5.10469 0.509524 5.10469 0.7C5.10469 0.795238 5.08548 0.895238 5.04705 1C5.01823 1.10476 4.975 1.18095 4.91736 1.22857C4.8405 1.30476 4.74924 1.36191 4.64356 1.4C4.53788 1.42857 4.43701 1.45238 4.34094 1.47143C4.24487 1.48095 4.16321 1.48571 4.09596 1.48571C4.02871 1.48571 3.99029 1.48571 3.98068 1.48571H3.33221C3.1881 1.48571 3.07282 1.50952 2.98636 1.55714C2.9095 1.60476 2.85186 1.67143 2.81343 1.75714C2.775 1.84286 2.75099 1.94286 2.74138 2.05714C2.74138 2.17143 2.74138 2.29048 2.74138 2.41429V3.44286C2.74138 3.66191 2.72697 3.83333 2.69815 3.95714C2.67893 4.08095 2.6357 4.2 2.56845 4.31429C2.51081 4.42857 2.42915 4.55238 2.32348 4.68571C2.22741 4.81905 2.10251 5 1.9488 5.22857C1.84313 5.39048 1.76627 5.51905 1.71824 5.61429C1.67981 5.70952 1.6654 5.79524 1.675 5.87143C1.68461 5.94762 1.71824 6.02857 1.77588 6.11429C1.83352 6.19048 1.90557 6.29048 1.99203 6.41429C2.12653 6.60476 2.24182 6.75238 2.33789 6.85714C2.43396 6.9619 2.51081 7.06667 2.56845 7.17143C2.6357 7.27619 2.67893 7.40952 2.69815 7.57143C2.72697 7.72381 2.74138 7.94286 2.74138 8.22857L2.72697 9.52857C2.71736 10.1857 2.9047 10.5143 3.28898 10.5143H3.90863C4.07194 10.5143 4.23526 10.5333 4.39858 10.5714C4.57151 10.6 4.72522 10.6667 4.85972 10.7714C4.99421 10.8762 5.06146 11.0238 5.06146 11.2143C5.06146 11.3095 5.04225 11.4095 5.00382 11.5143C4.975 11.619 4.93177 11.6952 4.87413 11.7429C4.79727 11.819 4.68199 11.8714 4.52828 11.9C4.38417 11.9381 4.23526 11.9619 4.08155 11.9714C3.93745 11.9905 3.80775 12 3.69247 12C3.57719 12 3.51474 12 3.50513 12L2.51081 11.9143C2.28024 11.9143 2.06889 11.8571 1.87675 11.7429C1.68461 11.6286 1.52129 11.4714 1.3868 11.2714C1.2619 11.0714 1.16103 10.8381 1.08418 10.5714C1.01693 10.2952 0.983302 10.0048 0.983302 9.7V8.48571C0.983302 8.33333 0.978499 8.20476 0.968892 8.1C0.968892 7.99524 0.959285 7.89524 0.940071 7.8C0.920857 7.70476 0.887232 7.60476 0.839198 7.5C0.80077 7.39524 0.743128 7.26667 0.666272 7.11429L0.190727 6.5C0.0466221 6.25238 -0.0158233 6.0381 0.00339071 5.85714C0.0226046 5.66667 0.0802464 5.4619 0.176316 5.24286L0.680682 4.57143C0.757538 4.42857 0.81518 4.31429 0.853608 4.22857C0.901643 4.13333 0.935267 4.04286 0.954481 3.95714C0.973695 3.87143 0.983302 3.78571 0.983302 3.7C0.992909 3.61429 0.997712 3.50952 0.997712 3.38571L0.983302 1.97143C0.983302 1.67619 1.02653 1.40952 1.113 1.17143C1.19946 0.92381 1.31955 0.714286 1.47326 0.542858C1.62697 0.371429 1.8095 0.238096 2.02086 0.142858C2.23221 0.0476193 2.45797 0 2.69815 0H3.93745Z',
	],
};

export const faBinary: IconDefinition = {
	prefix: 'fas',
	iconName: 'binary' as IconName,
	icon: [
		12,
		12,
		[],
		'',
		'M1 0.642857C1 0.287817 1.27473 0 1.61364 0H4.06818C4.40708 0 4.68182 0.287817 4.68182 0.642857V4.5C4.68182 4.85504 4.40708 5.14286 4.06818 5.14286H1.61364C1.27473 5.14286 1 4.85504 1 4.5V0.642857ZM2.22727 1.28571V3.85714H3.45455V1.28571H2.22727ZM6.31818 0.642857C6.31818 0.287817 6.59292 0 6.93182 0H8.15909C8.49799 0 8.77273 0.287817 8.77273 0.642857V3.85714H9.38636C9.72527 3.85714 10 4.14496 10 4.5C10 4.85504 9.72527 5.14286 9.38636 5.14286H6.93182C6.59292 5.14286 6.31818 4.85504 6.31818 4.5C6.31818 4.14496 6.59292 3.85714 6.93182 3.85714H7.54545V1.28571H6.93182C6.59292 1.28571 6.31818 0.997897 6.31818 0.642857ZM1 7.5C1 7.14496 1.27473 6.85714 1.61364 6.85714H2.84091C3.17981 6.85714 3.45455 7.14496 3.45455 7.5V10.7143H4.06818C4.40708 10.7143 4.68182 11.0021 4.68182 11.3571C4.68182 11.7122 4.40708 12 4.06818 12H1.61364C1.27473 12 1 11.7122 1 11.3571C1 11.0021 1.27473 10.7143 1.61364 10.7143H2.22727V8.14286H1.61364C1.27473 8.14286 1 7.85504 1 7.5ZM6.31818 7.5C6.31818 7.14496 6.59292 6.85714 6.93182 6.85714H9.38636C9.72527 6.85714 10 7.14496 10 7.5V11.3571C10 11.7122 9.72527 12 9.38636 12H6.93182C6.59292 12 6.31818 11.7122 6.31818 11.3571V7.5ZM7.54545 8.14286V10.7143H8.77273V8.14286H7.54545Z',
	],
};
export const faText: IconDefinition = {
	prefix: 'fas',
	iconName: 'text' as IconName,
	icon: [
		12,
		12,
		[],
		'',
		'M1.78814e-07 0.666667C1.78814e-07 0.298477 0.298477 0 0.666667 0H11.3333C11.7015 0 12 0.298477 12 0.666667C12 1.03486 11.7015 1.33333 11.3333 1.33333H0.666667C0.298477 1.33333 1.78814e-07 1.03486 1.78814e-07 0.666667ZM1.78814e-07 3.62963C1.78814e-07 3.26144 0.298477 2.96296 0.666667 2.96296H11.3333C11.7015 2.96296 12 3.26144 12 3.62963C12 3.99782 11.7015 4.2963 11.3333 4.2963H0.666667C0.298477 4.2963 1.78814e-07 3.99782 1.78814e-07 3.62963ZM0 6.59259C0 6.2244 0.298477 5.92593 0.666667 5.92593H11.3333C11.7015 5.92593 12 6.2244 12 6.59259C12 6.96078 11.7015 7.25926 11.3333 7.25926H0.666667C0.298477 7.25926 0 6.96078 0 6.59259ZM0 9.55556C0 9.18737 0.298477 8.88889 0.666667 8.88889H8.66667C9.03486 8.88889 9.33333 9.18737 9.33333 9.55556C9.33333 9.92375 9.03486 10.2222 8.66667 10.2222H0.666667C0.298477 10.2222 0 9.92375 0 9.55556Z',
	],
};
